/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.link.LinkNotActiveException;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathEvent;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathNotOpenException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class RcsPath {
    private static final String TRACE_MASKT = "XRCSPTHT";
    private static final String TRACE_MASKF = "XRCSPTHF";
    private static final String TRACE_MASKD = "XRCSPTHD";
    protected UUID uuid;
    protected PathState state;
    protected PathPlatform platform;
    protected PathPriority priority;
    protected PathCancelReason cancelReason;
    private static final long TIMEOUT = 14400000L;
    protected PathIdentifier pathId;
    protected LocalizableText text;
    protected Date origDate;
    protected String origSystem;
    protected PathCancelledListener cancelListener;
    private List supportedLinks;
    protected Object lock = new Object();
    private static final int CANCEL_TIMEOUT = 300000;
    private static Timer cancelTimer = new NamedTimer(true, "RcsPath Cancel Timer");
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-RCSPATH ");
    private TimerTask cancelTask;
    private Map linkData = new HashMap();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$RcsLink;

    public RcsPath() {
        this(PathPlatform.GENERIC, PathPriority.LOW, new LocalizableText("Rcs Path"));
    }

    public RcsPath(PathPriority priority, LocalizableText text) {
        this(PathPlatform.GENERIC, priority, text);
    }

    public RcsPath(PathPlatform platform, PathPriority priority, LocalizableText text) {
        this.platform = platform;
        this.priority = priority;
        this.text = text;
        this.uuid = UUIDFactory.generate();
        this.state = PathState.READY;
        this.origDate = new Date();
        this.origSystem = "localhost";
        this.pathId = new PathIdentifier(this);
        Trace.trace(TRACE_MASKT, "<-> RcsPath( " + platform + ", " + priority + ", " + text + " )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailability() throws InvalidStateException, PathCancelledException {
        Trace.trace(TRACE_MASKT, "--> waitForAvailability()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state != PathState.READY) {
                    throw new InvalidStateException(this.state, PathState.READY);
                }
                this.state = PathState.QUEUED;
                PathManager.getPathManager().addPath(this);
                Trace.trace(TRACE_MASKD, "  ] sleeping after addPath() until notified");
                this.lock.wait();
                Trace.trace(TRACE_MASKD, "  ] waking after addPath()");
                if (this.state == PathState.CANCELLED) {
                    throw new PathCancelledException();
                }
            }
            catch (PathCancelledException e) {
                throw e;
            }
            catch (InvalidStateException e) {
                throw e;
            }
            catch (Exception e) {
                ByteArrayOutputStream exDump = new ByteArrayOutputStream(1024);
                e.printStackTrace(new PrintStream(exDump));
                Trace.trace(TRACE_MASKF, "Exception: " + exDump.toString());
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1942);
                fl.add("RCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n" + "EXCEPTION CAUGHT: " + exDump);
                fl.log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- waitForAvailability()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        Trace.trace(TRACE_MASKT, "--> open()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.cancelTask != null) {
                    this.cancelTask.cancel();
                }
                if (this.state != PathState.WAITING) {
                    throw new InvalidStateException(this.state, PathState.WAITING);
                }
                this.state = PathState.OPENING;
                PathManager.getPathManager().openPath(this.pathId);
                Trace.trace(TRACE_MASKD, "  ] sleeping after openPath() until notified");
                this.lock.wait(14400000L);
                Trace.trace(TRACE_MASKD, "  ] waking after openPath()");
                if (this.state == PathState.OPENING) {
                    throw new InvalidStateException();
                }
                if (this.state == PathState.CANCELLED) {
                    if (this.cancelReason == PathCancelReason.LINK) {
                        PathFailedException e = new PathFailedException();
                        e.setReturnCode(PathManager.getPathManager().getReturnCode());
                        throw e;
                    }
                    throw new PathCancelledException();
                }
            }
            catch (PathCancelledException e) {
                throw e;
            }
            catch (PathFailedException e) {
                throw e;
            }
            catch (InvalidStateException e) {
                throw e;
            }
            catch (Exception e) {
                ByteArrayOutputStream exDump = new ByteArrayOutputStream(1024);
                e.printStackTrace(new PrintStream(exDump));
                Trace.trace(TRACE_MASKF, "Exception: " + exDump.toString());
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1942);
                fl.add("RCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n" + "EXCEPTION CAUGHT: " + exDump);
                fl.log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Trace.trace(TRACE_MASKT, "--> close()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == PathState.ACTIVE) {
                    this.state = PathState.CLOSING;
                } else {
                    this.state = PathState.CANCELLED;
                    this.cancelReason = PathCancelReason.APPLICATION;
                    this.lock.notify();
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream exDump = new ByteArrayOutputStream(1024);
                e.printStackTrace(new PrintStream(exDump));
                Trace.trace(TRACE_MASKF, "Exception: " + exDump.toString());
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1942);
                fl.add("RCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n" + "EXCEPTION CAUGHT: " + exDump);
                fl.log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        try {
            PathManager.getPathManager().closePath(this.pathId);
            this.state = PathState.READY;
        }
        catch (Exception e) {
            ByteArrayOutputStream exDump = new ByteArrayOutputStream(1024);
            e.printStackTrace(new PrintStream(exDump));
            Trace.trace(TRACE_MASKF, "Exception: " + exDump.toString());
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1942);
            fl.add("RCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n" + "EXCEPTION CAUGHT: " + exDump);
            fl.log(FrameworkLogAttributes.INFO_LOG);
        }
        Trace.trace(TRACE_MASKT, "<-- close()");
    }

    public boolean fail() {
        boolean fail = PathManager.getPathManager().failLink();
        this.close();
        Trace.trace(TRACE_MASKT, "<-> fail() [" + fail + "]");
        return fail;
    }

    public void setCancelListener(PathCancelledListener listener) throws NullPointerException {
        Trace.trace(TRACE_MASKT, "--> setCancelListener( " + listener + " )");
        if (listener == null) {
            throw new NullPointerException("The specified listener was null");
        }
        this.cancelListener = listener;
        Trace.trace(TRACE_MASKT, "<-- setCancelListener()");
    }

    public PathCancelReason getCancelReason() {
        if (this.cancelReason == null) {
            this.cancelReason = PathCancelReason.ERROR;
        }
        Trace.trace(TRACE_MASKT, "<-> getCancelReason() [" + this.cancelReason + "]");
        return this.cancelReason;
    }

    public void setDate(Date date) {
        Trace.trace(TRACE_MASKT, "<-> setDate( " + this.origDate + " )");
        this.origDate = date;
    }

    public Date getDate() {
        Trace.trace(TRACE_MASKT, "<-> getDate() [" + this.origDate + "]");
        return this.origDate;
    }

    public void setSystem(String system) {
        Trace.trace(TRACE_MASKT, "<-> setSystem( " + system + " )");
        this.origSystem = system;
    }

    public String getSystem() {
        Trace.trace(TRACE_MASKT, "<-> getSystem() [" + this.origSystem + "]");
        return this.origSystem;
    }

    public InetAddress getLinkAddress() throws PathNotOpenException {
        if (this.state != PathState.ACTIVE) {
            throw new PathNotOpenException();
        }
        InetAddress ip = null;
        try {
            ip = PathManager.getPathManager().getLinkAddress();
        }
        catch (LinkNotActiveException e) {
            throw new PathNotOpenException(e);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-> getLinkAddress() [" + ip + "]");
        return ip;
    }

    public void setSupportedLinkTypes(List links) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> setSupportedLinkTypes( " + links + " )");
        if (links == null) {
            this.supportedLinks = null;
            return;
        }
        Iterator i = links.iterator();
        while (i.hasNext()) {
            Class c;
            if ((class$com$ibm$hwmca$fw$rcs$link$RcsLink == null ? RcsPath.class$("com.ibm.hwmca.fw.rcs.link.RcsLink") : class$com$ibm$hwmca$fw$rcs$link$RcsLink).isAssignableFrom(c = (Class)i.next())) continue;
            throw new IllegalArgumentException(c + " is not a sublcass of " + (class$com$ibm$hwmca$fw$rcs$link$RcsLink == null ? (class$com$ibm$hwmca$fw$rcs$link$RcsLink = RcsPath.class$("com.ibm.hwmca.fw.rcs.link.RcsLink")) : class$com$ibm$hwmca$fw$rcs$link$RcsLink));
        }
        this.supportedLinks = links;
        Trace.trace(TRACE_MASKT, "<-- setSupportedLinkTypes()");
    }

    public List getSupportedLinkTypes() {
        Trace.trace(TRACE_MASKT, "<-> getSupportedLinkTypes() [" + this.supportedLinks + "]");
        return this.supportedLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(PathEvent event, Object info) {
        Trace.trace(TRACE_MASKT, "--> sendEvent( " + event + ", " + info + " )");
        Object object = this.lock;
        synchronized (object) {
            if (event == PathEvent.READY) {
                if (this.state == PathState.QUEUED) {
                    this.state = PathState.WAITING;
                    if (this.cancelTask != null) {
                        this.cancelTask.cancel();
                    }
                    Trace.trace(TRACE_MASKF, "Creating a new TimerTask, and scheduling for 300000 seconds");
                    this.cancelTask = new CancelTimerTask(this);
                    cancelTimer.schedule(this.cancelTask, 300000L);
                } else {
                    this.state = PathState.CANCELLED;
                    this.close();
                }
                this.lock.notify();
            } else if (event == PathEvent.OPENED) {
                this.state = this.state == PathState.OPENING ? PathState.ACTIVE : PathState.CANCELLED;
                this.lock.notify();
            } else if (event == PathEvent.CANCELLED) {
                this.cancelReason = (PathCancelReason)info;
                if (this.state == PathState.OPENING) {
                    this.state = PathState.CANCELLED;
                } else {
                    this.state = PathState.CANCELLED;
                    if (this.cancelListener != null) {
                        this.cancelListener.pathCancelled(this.cancelReason);
                    }
                }
                this.lock.notify();
            }
        }
        Trace.trace(TRACE_MASKT, "<-- sendEvent()");
    }

    public void sendEvent(PathEvent event) {
        Trace.trace(TRACE_MASKT, "<-> sendEvent( " + event + " )");
        this.sendEvent(event, null);
    }

    public void cancel(PathCancelReason reason) {
        Trace.trace(TRACE_MASKT, "<-> cancel( " + reason + " )");
        this.sendEvent(PathEvent.CANCELLED, reason);
    }

    public void setDescription(LocalizableText text) {
        Trace.trace(TRACE_MASKT, "<-> setDescription( " + text + " )");
        this.text = text;
    }

    public LocalizableText getDescription() {
        return this.text;
    }

    public PathState getState() {
        return this.state;
    }

    public PathPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(PathPlatform platform) {
        Trace.trace(TRACE_MASKT, "<-> setPlatform() [" + platform + "]");
        this.platform = platform;
    }

    public PathPriority getPriority() {
        return this.priority;
    }

    public void setPriority(PathPriority priority) {
        Trace.trace(TRACE_MASKT, "<-> setPriority() [" + priority + "]");
        this.priority = priority;
    }

    public PathIdentifier getPathIdentifier() {
        if (this.pathId == null) {
            this.pathId = new PathIdentifier(this);
        }
        Trace.trace(TRACE_MASKT, "<-> getPathIdentifier() [" + this.pathId + "]");
        return this.pathId;
    }

    public UUID getPathId() {
        return this.uuid;
    }

    public boolean isOpen() {
        return this.state == PathState.ACTIVE;
    }

    public boolean isHighPerformancePath() throws PathNotOpenException {
        if (this.state != PathState.ACTIVE) {
            throw new PathNotOpenException();
        }
        boolean hpl = false;
        try {
            hpl = PathManager.getPathManager().isHighPerformanceLink();
        }
        catch (LinkNotActiveException e) {
            throw new PathNotOpenException(e);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-> isHighPerformancePath() [" + hpl + "]");
        return hpl;
    }

    public void setLinkData(String key, Object value) {
        this.linkData.put(key, value);
    }

    public Object getLinkData(String key) {
        return this.linkData.get(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CancelTimerTask
    extends TimerTask {
        RcsPath path;

        public CancelTimerTask(RcsPath path) {
            Trace.trace(RcsPath.TRACE_MASKT, "<-> CancelTimerTask()");
            this.path = path;
        }

        public void run() {
            Trace.trace(RcsPath.TRACE_MASKT, "--> CancelTimerTask.run()");
            try {
                if (this.path.getState() == PathState.WAITING) {
                    this.path.close();
                }
            }
            catch (Exception e) {
                Trace.trace(RcsPath.TRACE_MASKF, "Exception: " + e);
            }
            Trace.trace(RcsPath.TRACE_MASKT, "<-- CancelTimerTask.run()");
        }
    }
}

